;**************************************************
;*                                                *
;*      t e r m . c 1  (new punter protocol)      *
;*      ------------------------------------      *
;*                                                *
;*               source = s/term.c1               *
;*               object = o/term.c1               *
;*                                                *
;*   this new punter protocol features adjust-    *
;* able data length (40-255 bytes), new hand-     *
;* shaking signals, and faster up/downloads.      *
;*                                                *
;*    - commented disassembly  by tom hughes -    *
;*                                                *
;*                    v081284                     *
;*                                                *
;**************************************************
.skip
;
;c-64 equates
;
.skip
z62    = $62 ;sys jump value/counter
z64    = $64 ;buffer pointer-lo
z65    = $65 ;  ''     ''   -hi
z96    = $96 ;psuedo-st register
;                         0 = ok
;                         1 = all bytes received ???
;                         2 = receive buffer empty
;                         4 = some bytes received
;                         8 = $c806/c807 = 0
zba    = $ba ;current device #
zf7    = $f7 ;rs-232 input buffer pointer-lo
zf8    = $f8 ;  ''     ''    ''      ''  -hi
.skip
x0200  = $0200 ;rs-232 byte/flag: block size
x028d  = $028d ;keybrd flag: 2 = cmdr pressed
x029b  = $029b ;ptr: end of rs-232 input buffer
x029c  = $029c ;ptr: start   ''      ''    ''
x02a1  = $02a1 ;rs-232 enables
.skip
rs2set = $ef7e ;enable rs-232 byte reception
chkin  = $ffc6 ;ready channel for output
chrin  = $ffcf ;input char to channel
chkout = $ffc9 ; ''     ''     '' input
chrout = $ffd2 ;output char to channel
clrchn = $ffcc ;i/o to default (screen)
getin  = $ffe4 ;get char from keyboard
readst = $ffb7 ;read/clear i/o status word
.page 'program storage'
xc800  = $c800 ;3-letter handshake
xc801  = $c801 ;    ''       ''
xc802  = $c802 ;    ''       ''
xc803  = $c803 ;sc051 loop counter (1,2,4,8,16,32)
xc804  = $c804 ;sc051 handshake ptr (0,3,6,9,12 or 15)
xc805  = $c805 ;sc051 entry value (0,4,8,11 or 16)
xc806  = $c806 ;sc051/sc27f flag: $ff=hshake rec'd
xc807  = $c807 ;    ''       ''         ''
xc808  = $c808 ;handshake index (0,3,6,8,12)
xc809  = $c809 ;# bytes in block/counter ???
xc80a  = $c80a ;(unused)
xc80b  = $c80b ;delay flag: 0=no delay if $c80c < 3
xc80c  = $c80c ;sc55e counter (0-3)
xc80d  = $c80d ;rec/xmit flag: 0 = 1st block
xc80e  = $c80e ;sc484 checksum workspace
xc80f  = $c80f ;  ''     ''       ''
xc810  = $c810 ;  ''     ''       ''
xc811  = $c811 ;  ''     ''       ''
xc812  = $c812 ;sc380 checksum workspace
xc813  = $c813 ;  ''     ''       ''
xc814  = $c814 ;  ''     ''       ''
xc815  = $c815 ;  ''     ''       ''
xc816  = $c816 ;$64/65 offset
xc817  = $c817 ;# bytes to send (set by $c904) ???
xc818  = $c818 ;block size (40-255)
xc819  = $c819 ;counter/flag: $ff for xmit start ???
xc81a  = $c81a ;      ''
xc81b  = $c81b ;filetype (1=prg, 2=seq, 3=wordpro)
xc81c  = $c81c ;entry stack pointer
xc81d  = $c81d ;xmit flag: 0=short blk/1=long blk
xc81e  = $c81e ;xmit flag: 0=send "goo"/1=send "syn"
.skip 2
;
;block header format ($c900=rec buff/$ca00=xmit buff)
;
.skip
xc900  = $c900 ;checksum 1 - sum
xc901  = $c901 ;    ''       ''
xc902  = $c902 ;checksum 2 - eor
xc903  = $c903 ;    ''       ''
xc904  = $c904 ;# bytes in header (7)
xc905  = $c905 ;# bytes in block ???
xc906  = $c906 ;error flag: $ff=???
xc907  = $c907 ;filetype (1-3)
.page 'jumps & data'
* = $c000 ;start @ 49152
.skip
;
;sys "adjustable" jump values
;
.skip
lda #0 ;sys 49152
.byt $2c
lda #3 ;sys 49155 (receive data-2)
.byt $2c
lda #6 ;sys 49158 (transmit data-2)
.byt $2c
lda #9 ;sys 49161 (receive data-1)
.byt $2c
lda #12 ;sys 49164 (transmit data-1)
.byt $2c
lda #15 ;sys 49167 (terminal mode)
nop
jmp jc018 ;set adjustable jump
.skip
jmp sc59b ;sys 49173 (rs-232 settup)
.skip
jc018 sta z62 ;(0,3,6,9,12,15)
tsx
stx xc81c ;save current stack ptr
lda #$30
clc
adc z62
sta adjump+1 ;set jump-lo
lda #>adjump
adc #0
sta adjump+2 ;set jump-hi
adjump jmp $0000
.skip
;
;jump table
;
jmp sc051 ;(sys 49152)
jmp sc408 ;receive 2 (sys 49155)
jmp sc3d0 ;transmit 2 (sys 49158)
jmp sc4ce ;receive 1 (sys 49161)
jmp sc517 ;transmit 1 (sys 49164)
jmp sc5aa ;terminal mode (sys 49167)
.skip
;
;handshake signals (sent by sc124)
;
hshake = * ;indexed by .y & $c808
.byt 'goo' ;.y = 0  (go)  ???
.byt 'bad' ;.y = 3  (bad block)
.byt 'ack' ;.y = 6  (acknowledge)
.byt 's/b' ;.y = 9  (send block) ???
.byt 'syn' ;.y = 12 (bbs ready) ???
.page 'receive handshake'
;----------------------------------------
;sc151: check for bbs handshake
;----------------------------------------
.skip
;entry: if .a = 0, don't check any
;               4, check for "ack" only
;               8,   ''   '' "s/b"  ''
;              11,   ''   '' "goo", "bad", or "s/b"
;              16,   ''   '' "syn" only
;exit: if received, $96 = 0 & $c806/c807 = 0
;      if not, $96 = 1
.skip
sc051 sta xc805 ;save entry value
lda #0 ;clear handshake storage
sta xc800
sta xc801
sta xc802
.skip
jc05f lda #0 ;clear counters/flags
sta xc806
sta xc807
jc067 jsr sc67b ;cmdr key pressed? (if yes,exit)
jsr sc0f2 ;get byte from rs-232 buffer
lda z96 ;byte in buffer?
bne bc0c9
lda xc801 ;yes, store @ $c800-c802
sta xc800
lda xc802
sta xc801
lda x0200 ;rs-232 byte
sta xc802
lda #0
sta xc804 ;handshake word ptr = 0
lda #1
sta xc803 ;set loop counter
.skip
;validate bbs handshake
;
bc08d lda xc805 ;(= 0,4,8,11 or 16)
bit xc803 ;(= 1,2,4,8,16 or 32)
beq bc0ab ;if equal, don't check hshake
ldy xc804
ldx #0
bc09a lda xc800,x ;else get bbs handshake word
cmp hshake,y ;same as table?
bne bc0ab
iny
inx
cpx #3
bne bc09a
jmp jc0be ;yes, set flags & get more bytes
.page
bc0ab asl xc803 ;times 2 (= 2,4,8,16 or 32)
lda xc804 ;set to next handshake word
clc
adc #3
sta xc804 ;bump index by 3
cmp #15 ;last word?
bne bc08d
jmp jc05f ;yes, try again
.skip
;handshake received from bbs
;
jc0be lda #$ff ;set flags
sta xc806
sta xc807
jmp jc067 ;and get more bytes
.skip
;rs-232 input buffer empty ($96 = 2)
;
bc0c9 inc xc806 ;bump counters/flags
bne bc0d1
inc xc807
bc0d1 lda xc807
ora xc806 ;handshake received?
beq bc0ec ;yes, exit
lda xc806
cmp #7 ;???
lda xc807
cmp #20 ;hi-count < 20?
bcc jc067
.skip
lda #1 ;no, set flag: hshake rec'd
sta z96
jmp sc55e ;delay/exit
.skip
bc0ec lda #0 ;flag: hshake received
sta z96
rts
.page 'input rs-232 byte'
;----------------------------------------
;sc0f1: get byte from rs-232 buffer
;----------------------------------------
.skip
;exit:  if byte, $0200 = byte/$96 = 0
;       if no byte, $0200 = 0/$96 = 2
.skip
sc0f1 nop
sc0f2 tya ;preserve .y
pha
lda x029b
cmp x029c ;input buffer empty?
beq bc112
ldy x029c
lda (zf7),y ;no, get byte from buffer
pha ;save
inc x029c ;bump buffer pointer
lda #0
sta z96 ;set flag = 0
pla
sta x0200 ;store byte
pla
tay ;restore .y
jmp jc11d
.skip
;rs-232 buffer empty
;
bc112 lda #2
sta z96 ;set flag = 2
lda #0
sta x0200 ;store null byte
pla
tay ;restore .y
.skip
jc11d pha ;preserve .y
lda #3
sta zba ;screen = current device
pla ;restore .y
rts
.page 'send handshake'
;----------------------------------------
;sc124: send handshake to bbs
;----------------------------------------
.skip
;entry:  if .y = 0, "goo"
;          ''    3, "bad"
;          ''    6, "ack"
;          ''    9, "s/b"
;          ''   12, "syn"
.skip
sc124 ldx #5 ;ready modem for output
jsr chkout
ldx #0
bc12b lda hshake,y
jsr chrout ;handshake -> modem
iny
inx
cpx #3 ;send 3 bytes
bne bc12b
jmp clrchn ;i/o to defaults, exit
.skip 2
;----------------------------------------
;sc13a: send handshake, get data @ $c900
;----------------------------------------
.skip
;entry:  .a = handshake word index (see above)
;             (0=1st block/1=all others)
.skip
sc13a sta xc808 ;save index
lda #0
sta xc80b ;flag: delay/exit if $c80c > 2
jc142 lda #2
sta z62 ;set attempt counter
ldy xc808
jsr sc124 ;send handshake
bc14c lda #4
jsr sc051 ;wait for bbs "ack"
lda z96 ;received?
beq bc15c
dec z62
bne bc14c
jmp jc142 ;no, try again
.page
;bbs "ack" received
;
bc15c ldy #9
jsr sc124 ;send "s/b" to bbs
lda xc80d ;flag: 1st block?
beq bc16b
lda xc808 ;flag: last hshake = "goo"?
beq bc18a ;yes, branch
.skip
;receive 1st block (8 bytes)
;
bc16b lda xc904 ;# of bytes to receive (8=start)
sta xc809
sta xc817
jsr sc27f ;receive bbs data @ $c900
lda z96
cmp #1 ;all bytes received?
beq bc189 ;yes, exit
cmp #2 ;receive buffer empty?
beq bc15c ;yes, send "s/b" again
cmp #4 ;1 or more bytes received?
beq bc189 ;yes, exit
cmp #8 ;counters at max?
beq bc15c ;yes, send "s/b" again
bc189 rts ;$96 = 1 or 4
.skip
;flag $c80d = 0 ("goo")
;
bc18a lda #16
jsr sc051 ;wait for bbs "syn"
lda z96 ;received?
bne bc15c ;no, send "s/b" again
.skip
lda #10
sta xc809
bc198 ldy #12
jsr sc124 ;yes, send "syn" to bbs
lda #8
jsr sc051 ;wait for  "s/b"
lda z96 ;received?
beq bc1ab
dec xc809 ;no, attempt 10 times
bne bc198
bc1ab rts ;$96 = 0 or 1
.page 'buffer -> bbs'
;----------------------------------------
;sc1ac:  send $c809 bytes -> bbs
;----------------------------------------
.skip
;exit: if .a = 0, good block
;        ''    1, bad block/last blk ???
.skip
sc1ac lda #1
sta xc80b ;flag: delay/exit
bc1b1 lda xc81e ;flag: 1=send "goo"/0=no "goo"
beq bc1bb
ldy #0
jsr sc124 ;send "goo"
bc1bb lda #11
jsr sc051 ;wait for "goo", "bad" or "s/b"
lda z96 ;one received?
bne bc1b1 ;no, try again
.skip
;either "goo", "bad" or "s/b" received
;
lda #0
sta xc81e ;flag: 0=no "goo"
lda xc804 ;was "goo" received?
cmp #0
bne bc205 ;no, print ":", send "ack" & header, exit
.skip
;"goo" received
;
lda xc80d ;flag: 1st block?
bne bc23d ;yes, print "*", send "ack" & "s/b",exit
inc xc819 ;(= 0 for 1st blk)
bne bc1dd
inc xc81a ;(= 0 for 1st blk)
bc1dd jsr sc364 ;set $64/65 = $ca00
ldy #5
iny
lda (z64),y ;$ca06 = $ff? (start?)
cmp #$ff
bne bc1ff ;no, disk -> buffer
lda #1
sta xc80d ;flag: not 1st block
lda xc816
eor #%00000001
sta xc816 ;reset $64/65 = $c900
jsr sc364
jsr sc344 ;compute block checksum
jmp jc202 ;send "ack" & $c809 bytes
.page
;disk -> buffer  ($c906/ca06 <> $ff)
;
bc1ff jsr sc2ff ;disk -> buffer
jc202 lda #'- ;"-" = good block
.byt $2c
bc205 lda #': ;":" = bad block
jsr sc586 ;print "-" or ":" (if $c80d = 0)
ldy #6
jsr sc124 ;send "ack"
lda #8
jsr sc051 ;wait for bbs "s/b"
lda z96 ;received?
bne jc202 ;no, try again
.skip
;bbs "s/b" received, send $c809 bytes
;
jsr sc364 ;set $64/65 = $ca00 ???
ldy #4
lda (z64),y ;get # of bytes in header
sta xc809 ;save
jsr sc371 ;set $64/65 = $c900 ???
ldx #5
jsr chkout ;ready modem for output
ldy #0
bc22c lda (z64),y ;$c809 bytes -> bbs
jsr chrout
iny
cpy xc809 ;# bytes in header ???
bne bc22c
jsr clrchn ;i/o to default
lda #0
rts
.page
;send short block "*" ???
;entry: $c80d <> 0
;
bc23d lda #'*
jsr sc586 ;print "*"
ldy #6
jsr sc124 ;send "ack" to bbs
lda #8
jsr sc051 ;wait for bbs hshake (except "s/b")
lda z96 ;received?
bne bc23d ;no, send again
.skip
;bbs handshake received
;
lda #10
sta xc809
bc255 ldy #11
jsr sc124 ;send "syn" to bbs
lda #16
jsr sc051 ;wait for bbs hshake (except "syn")
lda z96 ;received?
beq bc268
dec xc809 ;n0, try 10 times
bne bc255
.skip
;bbs handshake received
;
bc268 lda #3
sta xc809 ;set attempt counter
bc26d ldy #9
jsr sc124 ;send "s/b" 3 times
lda #0
jsr sc051 ;wait for any bbs handshake
dec xc809 ;-1 from attempt counter
bne bc26d
lda #1 ;flag: error ???
rts
.page 'bbs -> buffer'
;----------------------------------------
;sc27f: receive bbs data @ $c900
;----------------------------------------
.skip
sc27f ldy #0
bc281 lda #0
sta xc806 ;clear attempt counters
sta xc807
jc289 jsr sc67b ;cmdr key pressed?
jsr sc0f2 ;no, get rs-232 buffer byte
lda z96 ;byte in buffer?
bne bc2cf ;no, bump attempt count
.skip
;rs-232 byte received
;
lda x0200 ;get modem byte
sta xc900,y
cpy #3 ;3 handshake bytes received?
bcs bc2b9 ;yes, skip
.skip
sta xc800,y
cpy #2
bne bc2b9
lda xc800 ;first 3 bytes = "ack"?
cmp #'a
bne bc2b9
lda xc801
cmp #'c
bne bc2b9
lda xc802
cmp #'k
beq bc2c4 ;yes, branch
.skip
bc2b9 iny
cpy xc809 ;all bytes received?
bne bc281
lda #1 ;yes, set flag = 1
sta z96
rts
.skip
;"ack" received @ $c800-c802
;
bc2c4 lda #$ff
sta xc806 ;set flags to max
sta xc807
jmp jc289 ;get more bytes
.page
;handle $96 <> 0
;
bc2cf inc xc806 ;bump lo-counter
bne bc2d7
inc xc807 ;bump hi-counter
bc2d7 lda xc806
ora xc807 ;counters at max?
beq bc2fa
lda xc806
cmp #6 ;???
lda xc807
cmp #16 ;no, hi-counter < 16?
bne jc289 ;yes, try again
lda #2
sta z96 ;if no bytes, $96 = 2
cpy #0
beq bc2f7
lda #4 ;if 1+ bytes, $96 = 4
sta z96
bc2f7 jmp sc55e ;delay & exit
.skip
bc2fa lda #8 ;if counters = 0, $96 = 8
sta z96
rts
.page
;----------------------------------------
;sc2ff:  disk -> buffer
;----------------------------------------
.skip
sc2ff lda xc816 ;change current buffer
eor #%00000001
sta xc816
jsr sc364 ;set $64/65 = $ca00 ???
ldy #5
lda xc819 ;l-address send buffer ???
clc
adc #1 ;+1
sta (z64),y ;save @ $ca05/c905 ???
iny
lda xc81a ;h-address send buffer ???
adc #0
sta (z64),y ;save @ $ca06/c906 ???
ldx #2
jsr chkin ;ready ch 2 for input (disk)
ldy #7
bc323 jsr chrin ;get disk byte
sta (z64),y ;save  @ $ca07 on ...
iny
jsr readst ;st = 0?
bne bc338
cpy xc818 ;$c818 bytes received?
bne bc323
tya
pha ;preserve buffer pointer
jmp jc345
.skip
;st <> 0
;
bc338 tya
pha ;preserve buffer pointer
ldy #5
iny
lda #$ff
sta (z64),y ;set $ca06 = $ff
jmp jc345
.page 'checksum'
;----------------------------------------
;sc344: compute block checksum
;----------------------------------------
.skip
;entry: .a = $c804 (handshake word index)
;exit:  $c809 = # bytes in block
;       $c904 =     ''    ''   ???
;       checksum in header @ xx00-xx03
.skip
sc344 pha ;save index
.skip
jc345 jsr clrchn ;i/o to defaults
jsr sc59b ;enable byte reception
jsr sc579 ;delay loop
jsr sc59b ;enable byte reception
ldy #4
lda (z64),y ;get # of bytes in block
sta xc809 ;save
jsr sc371 ;set $64/65 = $c900
pla ;get buffer pointer
ldy #4
sta (z64),y ;save as # bytes in block
jsr sc380 ;compute block checksum
rts
.page 'set $64/65'
;----------------------------------------
;sc364: set $64/65 - ascending
;----------------------------------------
.skip
;entry: if $c816 = 0, $64/65 = $c900
;            ''    1,   ''     $ca00
.skip
sc364 lda #0
sta z64
lda xc816 ;pointer offset
clc
adc #$c9 ;$c816 + $c9 = $65
sta z65
rts
.skip 2
;----------------------------------------
;sc371: set $64/65 - change buffer
;----------------------------------------
.skip
;entry: if $c816 = 0, $64/65 = $ca00
;             ''   1,    ''    $c900
.skip
sc371 lda #0
sta z64
lda xc816 ;pointer offset
eor #%00000001 ;change buffer
clc
adc #$c9
sta z65
rts
.page 'checksum 2'
;----------------------------------------
;sc380: compute block checksum
;----------------------------------------
.skip
;entry: $c809 = # bytes in block
;exit:  $c814-c815 contains checksum
;       $c902-c903    ''       ''     ???
.skip
sc380 lda #0
sta xc812 ;checksum 1 - sum of bytes
sta xc813
sta xc814 ;checksum 2 - eor of bytes
sta xc815
ldy #4 ;checksum from $c904 on in blk
bc390 lda xc812
clc
adc (z64),y
sta xc812
bcc bc39e
inc xc813
bc39e lda xc814
eor (z64),y
sta xc814
lda xc815
rol a ;$c815 carry -> bit 0
rol xc814 ;$c814 carry -> bit 0
rol xc815 ;$c815      ''
iny
cpy xc809 ;end of block?
bne bc390
.skip
ldy #0
lda xc812 ;checksum 1 -> $c900/c901
sta (z64),y
iny
lda xc813
sta (z64),y
iny
lda xc814 ;checksum 2 -> $c902/c903
sta (z64),y
iny
lda xc815
sta (z64),y
rts
.page 'transmit 2'
;========================================
;sc3d0: transmit 2 - buffer to bbs
;========================================
.skip
;exit: $0200 = 0
.skip
sc3d0 lda #0
sta xc80d ;flag: 1st block?
sta xc80c ;delay counter
sta xc81d ;short blk # bytes ???
lda #1
sta xc816 ;transmit buffer @ $ca00
lda #$ff
sta xc819 ;set for xmit
sta xc81a
jsr sc371 ;set $64/65 = $c900
ldy #4
lda #7
sta (z64),y ;$c904 = 7 (# header bytes)
jsr sc364 ;set $64/65 = $ca00
ldy #5
lda #0
sta (z64),y ;$ca05 = 0 (# block bytes-lo)
iny
sta (z64),y ;$ca06 = 0 (# block bytes-hi)
bc3fd jsr sc1ac ;block(s) -> bbs ... ???
beq bc3fd
bc402 lda #0
sta x0200 ;flag: end of transmission
rts
.page 'receive 2'
;========================================
;sc408: receive 2 - buffer to disk
;========================================
.skip
sc408 lda #1
sta xc819 ;flag: receive ???
lda #0
sta xc81a ;???
sta xc80d ;flag: 1st block
sta xc816 ;receive buffer @ $c900
sta xc905 ;# bytes in block  ???
sta xc906 ;flag: $ff = short blk ???
sta xc80c ;delay counter
lda #7
sta xc904 ;7 bytes in header
lda #0
jc428 jsr sc13a ;bbs data -> buffer $c900 ???
lda xc80d ;flag: 1st block?
bne bc402 ;yes, set $0200 = 0 & exit
jsr sc484 ;block checksum ok?
bne bc471
.skip
;block ok, send to disk
;
jsr clrchn ;i/o to defaults
lda xc809 ;# bytes in block
cmp #7 ;= 7 (just block header)? ???
beq bc455
ldx #2
jsr chkout ;no, ready ch 2 for output (disk)
ldy #7
bc446 lda xc900,y ;$c907 to $c907+$c809 -> disk
jsr chrout
iny
cpy xc809
bne bc446
jsr clrchn ;i/o to defaults
.page
;just "header" or short block
;
bc455 lda xc906
cmp #$ff ;short block? ???
bne bc464
lda #1
sta xc80d ;flag: 1st block
lda #'* ;print "*"
.byt $2c
bc464 lda #'- ;no, print "-"
jsr chrout
jsr sc59b ;enable rs-232 byte reception
lda #0 ;send "goo"
jmp jc428 ;get next block
.skip
;block checksum bad
;
bc471 jsr clrchn ;i/o to defaults
lda #': ;print ":"
jsr chrout
lda xc817 ;# bytes received ???
sta xc904 ;save in block header
lda #3 ;send "bad"
jmp jc428 ;try again
.page 'checksum 3'
;----------------------------------------
;sc484: verify checksum for bbs block
;----------------------------------------
.skip
;entry: $c900-c903 = bbs block checksum
;exit:  if .a = 0, checksum ok
;          ''   1, bad checksum
.skip
sc484 lda xc900 ;checksum 1 - sum of bytes
sta xc80e
lda xc901
sta xc80f
lda xc902 ;checksum 2 - eor of bytes
sta xc810
lda xc903
sta xc811
jsr sc364 ;set $64/65 = $c900  ???
lda xc817 ;# bytes in block
sta xc809
jsr sc380 ;compute block checksum @ $c900 ???
lda xc900 ;checksum ok?
cmp xc80e
bne bc4cb
lda xc901
cmp xc80f
bne bc4cb
lda xc902
cmp xc810
bne bc4cb
lda xc903
cmp xc811
bne bc4cb
lda #0 ;yes, set .a = 0
rts
bc4cb lda #1 ;no, set .a = 1
rts
.page 'receive 1'
;========================================
;sc4ce: receive 1
;========================================
.skip
;exit: if short block, $0200 = 0
.skip
sc4ce lda #0
sta xc819 ;set flags
sta xc81a
sta xc80d ;flag: 1st block
sta xc816 ;$64/65 = $c900
sta xc80c ;delay counter
lda #7
clc
adc #1
sta xc904 ;# bytes to send = 8 (header+1)
lda #0 ;start handshake = "goo"
.skip
jc4e9 jsr sc13a ;send handshake, get data
lda xc80d ;flag: 1st block?
bne bc511
.skip
jsr sc484 ;block checksum ok?
bne bc506 ;no
lda xc907 ;1st data byte of block
sta xc81b ;= filetype
lda #1
sta xc80d ;flag: 1st block?
lda #0 ;send "goo"
jmp jc4e9 ;get next block
.skip
;block checksum bad
;
bc506 lda xc817 ;# bytes received
sta xc904 ;save in header
lda #3 ;send "bad"
jmp jc4e9 ;try again
.skip
;short block ($c80d <> 0)  ???
;
bc511 lda #0 ;set flag
sta x0200
rts ;back to basic
.page 'transmit 1'
;========================================
;sc517: transmit 1
;========================================
.skip
;exit: if transmit ok, then $0200 = 0
.skip
sc517 lda #0
sta xc80d ;flag: 0 = 1st block
sta xc80c ;set delay counter ???
lda #1
sta xc816 ;set $64/65 = $ca00
sta xc81d ;set short block flag ???
lda #$ff
sta xc819 ;flag: transmit  ???
sta xc81a
jsr sc371 ;set $64/65 = $c900
ldy #4
lda #7
clc
adc #1
sta (z64),y ;$c904 = 8 (min # bytes to send)
jsr sc364 ;set $64/65 = $ca00
ldy #5
lda #$ff
sta (z64),y ;$ca05 = $ff
iny
sta (z64),y ;$ca06 = $ff
ldy #7
lda xc81b ;file type
sta (z64),y ;$ca07 = file type (1-3)
lda #1
sta xc81e ;flag: wait for bbs "syn"
bc553 jsr sc1ac ;send block(s)
beq bc553
lda #0
sta x0200 ;flag: ???
rts ;back to basic
.skip 2
;----------------------------------------
;sc55e: transmit - delay exit  ???
;----------------------------------------
.skip
sc55e inc xc80c ;set @ 0 or 1
lda xc80c
cmp #3 ;< 3?
bcc bc574
lda #0 ;no, reset
sta xc80c
lda xc80b ;delay flag set?
beq sc579 ;yes, delay & exit
bne bc585 ;no, just exit
.skip
bc574 lda xc80b ;delay?
beq bc585 ;no, quit
.page 'misc subs'
;----------------------------------------
;sc579: delay
;----------------------------------------
.skip
sc579 ldx #0 ;set delay counters
bc57b ldy #0
bc57d iny
bne bc57d
inx
cpx #$78
bne bc57b
bc585 rts
.skip 2
;----------------------------------------
;sc586: send byte   ???
;----------------------------------------
.skip
;entry: .a = byte to sent
;exit:  .a =   ''    ''
.skip
sc586 pha ;preserve byte
lda xc819 ;flag: $ff for xmit ???
ora xc81a
beq bc599 ;yes, exit
lda xc80d ;flag: 1st block
bne bc599 ;yes,  exit
pla
jsr chrout ;send byte
pha
bc599 pla ;restore byte
rts
.skip 2
;========================================
;sc59b: enable rs-232 byte reception
;========================================
.skip
;entry: device 2 (modem) must be opened
.skip
sc59b jsr rs2set ;enable
lda x02a1 ;check for interrupts...
cmp #%10000000 ;nmi?
beq sc59b
cmp #%10010010 ;waiting or receiving?
beq sc59b
rts ;none of the above
.page 'terminal mode'
;========================================
;sc5aa: terminal mode
;========================================
.skip
sc5aa jsr sc667 ;print crsr, check cmdr key
bc5ad jsr sc0f1 ;get rs-232 byte
lda z96 ;byte received?
bne bc5c8
lda x0200 ;yes, get byte
and #%01111111 ;make it 7-bit
sta x0200
cmp #8 ;ascii delete?
beq bc5cb
cmp #13 ;ascii c/r?
beq bc5cb
cmp #32 ;ascii space?
bpl bc5cb ;any of the above
.skip
bc5c8 jmp jc615 ;check keyboard
.skip
bc5cb cmp #$61 ;ascii lowercase ($61-7a)?
bcc bc5dc
cmp #$7b
bcs bc5dc
sec ;yes, make cbm lowercase (-32)
sbc #32
sta x0200 ;save
jmp jc5ea
.skip
bc5dc cmp #$41 ;ascii uppercase ($41-5a)?
bcc jc5ea
cmp #$5b
bcs jc5ea
clc ;yes, make cbm uppercase (+128)
adc #128
sta x0200 ;save
.skip
jc5ea cmp #8 ;delete?
bne bc5f3
lda #20 ;yes, save cbm delete
sta x0200
bc5f3 cmp #34 ;quotes?
bne bc601
jsr chrout ;yes, print quotes
lda #20
jsr chrout ;+ delete
lda #34 ;save quotes
bc601 sta x0200
cmp #13 ;c/r?
bne bc60f
lda #32
jsr chrout ;yes, print space & c/r
lda #13
bc60f jsr chrout ;print char
jsr sc667 ;print crsr, cmdr pressed?
.skip
;check for keyboard input
;
jc615 jsr getin ;key pressed?
beq bc5ad ;no, check rs-232
sta x0200 ;yes, save keyboard char
cmp #19 ;home?
beq bc666 ;yes, exit to basic
cmp #$41 ;cbm lowercase ($41-5a)?
bcc bc632
cmp #$5b
bcs bc632
clc ;yes, make ascii lowercase (+32)
adc #32
sta x0200
jmp jc643
.skip
bc632 lda x0200
cmp #$c1 ;cbm uppercase-2 ($c1-da)?
bcc jc643
cmp #$db
bcs jc643
sec ;yes, make ascii uppercase (-128)
sbc #128
sta x0200
.skip
jc643 cmp #20 ;cbm delete?
bne bc64c
lda #8 ;yes, make ascii bs
sta x0200
bc64c cmp #$83 ;cbm shift/stop?
bne bc655
lda #16 ;yes, make ascii control p
sta x0200
bc655 ldx #5
jsr chkout ;ready rs-232 for output
lda x0200
jsr chrout ;send byte
jsr clrchn ;i/o to defaults
jmp sc5aa ;back to start...
bc666 rts ;if "home", exit to basic
.page 'crsr & cmdr'
;----------------------------------------
;sc667: print crsr, check if cmdr pressed
;----------------------------------------
.skip
sc667 lda #18
jsr chrout ;print rvs on
lda #32
jsr chrout ;space
lda #157
jsr chrout ;crsr left
lda #146
jsr chrout ;and rvs off
.skip 2
;----------------------------------------
;sc67b: check if cmdr key pressed
;----------------------------------------
.skip
;exit: x0200 = 1 (exit to terminal mode)
.skip
sc67b lda x028d
cmp #2 ;cmdr pressed?
bne bc689
bc682 pla ;yes, pop stack
tsx
cpx xc81c ;till basic entry
bne bc682
bc689 lda #1 ;set flag
sta x0200
